<?php
header('Content-Type: application/json');
include_once 'conexion.php';

$database = new Database();
$conn = $database->getConnection();

function limpiarDatos($data) {
    return htmlspecialchars(stripslashes(trim($data)));
}

// Verificar si el formulario fue enviado por POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $nombre = trim($_POST['nombre'] ?? '');
    $correo = trim($_POST['correo'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (empty($nombre) || empty($correo) || empty($password)) {
        echo json_encode(['respuesta' => false, 'mensaje' => 'El campo nombre, correo o contraseña son inválidos.']);
        exit();
    }

    if (strlen($password) < 8) {
        echo json_encode(['respuesta' => false, 'mensaje' => 'La contraseña debe tener al menos 8 caracteres.']);
        exit();
    }

    // Permitir espacios en el nombre
    if (!preg_match('/^[a-zA-Z0-9._\-\s]+$/', $nombre)) {
        echo json_encode(['respuesta' => false, 'mensaje' => 'El nombre contiene caracteres inválidos.']);
        exit();
    }

    if (!filter_var($correo, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['respuesta' => false, 'mensaje' => 'El correo no es válido.']);
        exit();
    }

    // Verificar si el usuario ya existe en la base de datos
    $sql = "SELECT * FROM usuarios WHERE correo = :correo";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":correo", $correo);
    $stmt->execute();

    if ($stmt->rowCount() == 0) {
        // Encriptar la contraseña
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);
        $fecha_registro = date("Y-m-d H:i:s");

        // Insertar nuevo usuario sin token
        $sql_insert = "INSERT INTO usuarios (nombre, correo, password, fecha_registro) VALUES (:nombre, :correo, :password, :fecha_registro)";
        $stmt_insert = $conn->prepare($sql_insert);
        $stmt_insert->bindParam(":nombre", $nombre);
        $stmt_insert->bindParam(":correo", $correo);
        $stmt_insert->bindParam(":password", $hashed_password);
        $stmt_insert->bindParam(":fecha_registro", $fecha_registro);

        if ($stmt_insert->execute()) {
            $usuario_id = $conn->lastInsertId();

            // Responder con los datos del usuario (sin token)
            echo json_encode([
                'respuesta' => true,
                'mensaje' => 'Registro exitoso',
                'user' => [
                    'id' => $usuario_id,
                    'correo' => $correo,
                    'fecha_registro' => $fecha_registro,
                ]
            ]);
        } else {
            echo json_encode(['respuesta' => false, 'mensaje' => 'Error al registrar el usuario.']);
        }
    } else {
        echo json_encode(['respuesta' => false, 'mensaje' => 'El usuario ya está registrado.']);
    }
}
?>