<?php


require_once '../vendor/autoload.php'; // Asegúrate de que este archivo exista y sea correcto
use Firebase\JWT\JWT; // Importar la clase JWT

include_once 'conexion.php';
$database = new Database();
$conn = $database->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if (isset($_POST['correo']) && isset($_POST['password'])) {
        $correo = $_POST['correo'];
        $password = $_POST['password'];

        $query = "SELECT id,correo,password,nombre FROM usuarios WHERE correo = :correo";
        $stmt = $conn->prepare($query);
        $stmt->bindParam(':correo', $correo);

        if ($stmt->execute()) {
            $user = $stmt->fetch(PDO::FETCH_ASSOC);

            // Verificar la contraseña encriptada
            if ($user && password_verify($password, $user['password'])) {
                // Generar token JWT
                $payload = [
                    'id' => $user['id'],
                    'correo' => $user['correo'],
                    'nombre' => $user['nombre'],
                    'iat' => time(), // Tiempo de emisión
                    'exp' => time() + (60 * 60 * 24 * 30) // Expira en 30 días
                ];
                $token = JWT::encode($payload, 'c3f8e7a9b2d4f6a1c9e8f7b3a6d5e4c2f1b0a9c8d7e6f5b4a3c2d1e0f9b8a7c6', 'HS256'); // Clave secreta más segura

                echo json_encode([
                    'respuesta' => true,
                    'mensaje' => 'Login exitoso',
                    'token' => $token,
                    'id' => $user['id'],
                    'correo' => $user['correo'],
                    'nombre' => $user['nombre'],
                ]);
            } else {
                echo json_encode([
                    'respuesta' => false,
                    'mensaje' => 'Credenciales inválidas'
                ]);
            }
        } else {
            echo json_encode([
                'respuesta' => false,
                'mensaje' => 'Error al ejecutar la consulta'
            ]);
        }
    } else {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'Parámetros incompletos'
        ]);
    }

} else {
    echo json_encode([
        'respuesta' => false,
        'mensaje' => 'Método no permitido'
    ]);
}
?>
