<?php
require_once '../vendor/autoload.php'; // Asegúrate de instalar la librería Firebase\JWT

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

class JWT_Helper {
    private static $secretKey = 'c3f8e7a9b2d4f6a1c9e8f7b3a6d5e4c2f1b0a9c8d7e6f5b4a3c2d1e0f9b8a7c6'; // Cambia esto por una clave segura

    public static function encode($payload) {
        return JWT::encode($payload, self::$secretKey, 'HS256');
    }

    public static function decode($token) {
        try {
            return JWT::decode($token, new Key(self::$secretKey, 'HS256'));
        } catch (Exception $e) {
            return null; // Retorna null si el token no es válido
        }
    }

    /**
     * Extraer el email del token JWT.
     *
     * @param string $token El token JWT.
     * @return string|null El email extraído o null si no se encuentra.
     */
    public static function extract_email_from_jwt($token) {
        $decoded = self::verify_jwt($token);
        if ($decoded && isset($decoded->email)) {
            return $decoded->email;
        }
        return null;
    }

    public static function verify_jwt($token) {
        $secret_key = self::$secretKey; // Cambia esto por tu clave secreta
        try {
            $decoded = JWT::decode($token, new Key($secret_key, 'HS256'));
            return $decoded;
        } catch (Exception $e) {
            return false;
        }
    }
}
?>
