<?php
require_once 'conexion.php';
// Obtener conexión PDO
$db = new Database();
$conn = $db->getConnection();


if ($email) {
    $stmt = $conn->prepare("SELECT * FROM premium WHERE correo = :email");
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($result) {
        echo json_encode([
            'respuesta' => true,
            'premium' => (bool)$result['premium'],
        ]);
    } else {
        // Crear registro nuevo con premium=false
        $insert = $conn->prepare("INSERT INTO premium (correo, premium) VALUES (:email, :premium)");
        $premiumValue = false;
        $insert->bindParam(':email', $email);
        $insert->bindParam(':premium', $premiumValue, PDO::PARAM_BOOL);
        $insert->execute();
        echo json_encode([
            'respuesta' => true,
            'premium' => false,
        ]);
    }
} else {
    echo json_encode(['respuesta' => false, 'mensaje' => 'Email no proporcionado']);
}
?>