<?php
function log_error_to_txt($message) {
    $logFile = 'error_log.txt';
    $date = date('Y-m-d H:i:s');
    $entry = "[$date] $message\n";
    file_put_contents($logFile, $entry, FILE_APPEND);
}

// Manejador de errores
set_error_handler(function($errno, $errstr, $errfile, $errline) {
    log_error_to_txt("Error [$errno] $errstr en $errfile línea $errline");
});

// Manejador de excepciones
set_exception_handler(function($exception) {
    log_error_to_txt("Excepción no capturada: " . $exception->getMessage() . " en " . $exception->getFile() . " línea " . $exception->getLine());
});
?>
