<?php
require_once 'conexion.php';

function generarSlugAleatorio($conn, $longitud = 6) {
    do {
        $slug = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, $longitud);
        $stmt = $conn->prepare("SELECT COUNT(*) FROM urls WHERE slug = ?");
        $stmt->execute([$slug]);
        $count = $stmt->fetchColumn();
    } while ($count > 0);
    return $slug;
}

// Obtener conexión PDO
$db = new Database();
$conn = $db->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  
    $slug = $_POST['SegundaMitad'] ?? null;
    $destino = $_POST['UrlDestino'] ?? null;
    $titulo = $_POST['titulo'] ?? null;
    if (!$titulo || trim($titulo) === '') {
        $titulo = 'sin título';
    }

    // Validar que el email esté presente


    // Validar UrlDestino como dominio o URL válida (permite sin esquema)
    if (
        !$destino ||
        !preg_match('/^(https?:\/\/)?([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}(\/.*)?$/', $destino)
    ) {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'UrlDestino no es un formato válido'
        ]);
        exit;
    }

    // Validar slug si viene definido
    if ($slug && trim($slug) !== '') {
        // Solo letras, números, longitud entre 4 y 32
        if (!preg_match('/^[a-zA-Z0-9]{4,32}$/', $slug)) {
            echo json_encode([
                'respuesta' => false,
                'mensaje' => 'SegundaMitad debe contener solo letras y números, longitud entre 4 y 32'
            ]);
            exit;
        }
    }

    if (!$email || !$destino) {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'Faltan parámetros requeridos'
        ]);
        exit;
    }

    if (!$slug || trim($slug) === '') {
        $slug = generarSlugAleatorio($conn);
    } else {
        // Verificar que el slug no exista
        $stmt = $conn->prepare("SELECT COUNT(*) FROM urls WHERE slug = ?");
        $stmt->execute([$slug]);
        $count = $stmt->fetchColumn();
        if ($count > 0) {
            http_response_code(409);
            echo json_encode([
                'respuesta' => false,
                'mensaje' => 'El slug ya existe'
            ]);
            exit;
        }
    }

    $stmt = $conn->prepare("INSERT INTO urls (titulo, correo, slug, url_destino) VALUES (?, ?, ?, ?)");
    if ($stmt->execute([$titulo, $email, $slug, $destino])) {
       
         
        
        echo json_encode([
            'respuesta' => true,
            'mensaje' => 'Enlace generado exitosamente',
            'titulo' => $titulo,
            'correo' => $email,
            'slug' => 'https://dlyyn.com/'.$slug,
            'url_destino' => $destino
        ]);

    } else {
        http_response_code(500);
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'Error al registrar el enlace'
        ]);
    }
}

?>