<?php
require_once 'conexion.php';

// Obtener conexión PDO
$db = new Database();
$conn = $db->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? null;
    $destino = $_POST['UrlDestino'] ?? null;
    $titulo = $_POST['titulo'] ?? null;

    if (!$id || !is_numeric($id)) {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'ID inválido'
        ]);
        exit;
    }

    if (!$email || trim($email) === '') {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'Email es requerido'
        ]);
        exit;
    }

    if (!$titulo || trim($titulo) === '') {
        $titulo = 'sin título';
    }

    // Validar UrlDestino como dominio o URL válida (permite sin esquema)
    if (
        !$destino ||
        !preg_match('/^(https?:\/\/)?([a-zA-Z0-9-]+\.)+[a-zA-Z]{2,}(\/.*)?$/', $destino)
    ) {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'UrlDestino no es un formato válido'
        ]);
        exit;
    }

    // Verificar que el enlace existe y pertenece al usuario
    $stmt = $conn->prepare("SELECT * FROM urls WHERE id = ? AND correo = ?");
    $stmt->execute([$id, $email]);
    $enlace = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$enlace) {
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'No se encontró el enlace o no pertenece al usuario'
        ]);
        exit;
    }

    // Actualizar título y url_destino
    $stmt = $conn->prepare("UPDATE urls SET titulo = ?, url_destino = ? WHERE id = ?");
    if ($stmt->execute([$titulo, $destino, $id])) {
        echo json_encode([
            'respuesta' => true,
            'mensaje' => 'Enlace actualizado exitosamente',
            'id' => $id,
            'titulo' => $titulo,
            'url_destino' => $destino,
            'slug' => 'https://dlyyn.com/'.$enlace['slug']
        ]);
    } else {
        http_response_code(500);
        echo json_encode([
            'respuesta' => false,
            'mensaje' => 'Error al actualizar el enlace'
        ]);
    }
}
?>
