<?php
require '../vendor/autoload.php';

use Google_Client;
use Google_Service_AndroidPublisher;

// Leer los datos enviados desde la app
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

$packageName = 'com.grupodailyn.tempmail'; // ⚠️ Reemplaza con tu package real
$productId = $data['productId'] ?? '';
$purchaseToken = $data['purchaseToken'] ?? '';
$transactionId = $data['transactionId'] ?? '';

// Leer el usuario enviado desde la app
$usuario = $data['usuario'] ?? '';

// Validar que los parámetros no estén vacíos
if (empty($productId) || empty($purchaseToken) || empty($usuario)) {
    echo json_encode([
        'valida' => false,
        'error' => 'Faltan parámetros obligatorios.'
    ]);
    exit;
}

// Configura cliente de Google
$client = new Google_Client();
$client->setAuthConfig('tempmail-bb679-4d3e7363f6c3.json'); // ⚠️ Reemplaza con tu JSON
$client->addScope(Google_Service_AndroidPublisher::ANDROIDPUBLISHER);

$service = new Google_Service_AndroidPublisher($client);

try {
    // Verificamos la suscripción
    $response = $service->purchases_subscriptions->get(
        $packageName,
        $productId,
        $purchaseToken
    );

    // Puedes guardar estos datos en tu base de datos si lo deseas
    $isActive = $response->getPaymentState() == 1; // 1 = pago exitoso
    $expiryTimeMillis = $response->getExpiryTimeMillis();

    if ($isActive) {
        // Conexión a la base de datos
        $pdo = new PDO('mysql:host=localhost;dbname=daniel_tempmail', 'daniel_tempmail', '2324DanielGS.');
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        // Actualizar la tabla premium
        $stmt = $pdo->prepare("UPDATE premium SET premium = 1, diadepago = :expira WHERE usuario = :usuario");
        $result = $stmt->execute([
            ':expira' => date('Y-m-d H:i:s', $expiryTimeMillis / 1000), // Convertir de milisegundos a fecha
            ':usuario' => $usuario
        ]);

        if (!$result) {
            throw new Exception("Error al actualizar la base de datos.");
        }
    }

    echo json_encode([
        'valida' => $isActive,
        'expira' => $expiryTimeMillis,
        'estado' => $response->getPaymentState()
    ]);

} catch (Exception $e) {
    echo json_encode([
        'valida' => false,
        'error' => $e->getMessage()
    ]);
}
