<?php
// Conexión a la base de datos
$host = 'localhost'; // Cambia según tu configuración
$dbname = 'daniel_tempmail';
$username = 'daniel_tempmail';
$password = '2324DanielGS.';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtener datos enviados por JavaScript
    $data = json_decode(file_get_contents('php://input'), true);

    // Validar que los datos existen
    if (isset($data['user'], $data['amount'], $data['status'])) {
        $user = $data['user'];
        $amount = $data['amount'];
        $status = $data['status'];

        // Iniciar la transacción
        $pdo->beginTransaction();

        // Insertar registro del pago en la base de datos
        $stmt = $pdo->prepare("INSERT INTO pagos (usuario, monto, estado, fecha) VALUES (:user, :amount, :status, NOW())");
        $stmt->bindParam(':user', $user);
        $stmt->bindParam(':amount', $amount);
        $stmt->bindParam(':status', $status);

        if ($stmt->execute()) {
            // Si el pago se registró correctamente, actualizamos la tabla premium
            $fecha_pago = date('Y-m-d H:i:s'); // Fecha y hora actuales

            $updateStmt = $pdo->prepare("UPDATE premium SET premium = 1, diadepago = :fecha_pago WHERE usuario = :user");
            $updateStmt->bindParam(':fecha_pago', $fecha_pago);
            $updateStmt->bindParam(':user', $user);

            if ($updateStmt->execute()) {
                // Confirmar los cambios en la base de datos
                $pdo->commit();
                echo json_encode(['success' => true, 'message' => 'Pago registrado y estado de premium actualizado correctamente']);
            } else {
                // Si el update no fue exitoso, revertimos la transacción
                $pdo->rollBack();
                echo json_encode(['success' => false, 'message' => 'Error al actualizar el estado premium']);
            }
        } else {
            // Si no se pudo registrar el pago, revertimos la transacción
            $pdo->rollBack();
            echo json_encode(['success' => false, 'message' => 'Error al registrar el pago']);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Datos incompletos']);
    }
} catch (PDOException $e) {
    // En caso de error en la conexión o en la transacción, revertir cambios y mostrar mensaje
    $pdo->rollBack();
    echo json_encode(['success' => false, 'message' => 'Error de conexión: ' . $e->getMessage()]);
}
?>
