<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';

// Conectar a la base de datos
$database = new Database();
$db = $database->getConnection();


// Verificar si el usuario existe y si la contraseña es correcta
    // Si el usuario existe, buscar en la tabla premium
    $queryPremium = "SELECT premium FROM premium WHERE email = :email"; // Solo selecciona el campo premium
    $stmtPremium = $db->prepare($queryPremium);
    $stmtPremium->bindParam(':email', $email);
    $stmtPremium->execute();

    $premiumData = $stmtPremium->fetch(PDO::FETCH_ASSOC); // Cambiado a fetch para obtener una sola fila

    // Devolver los datos en formato JSON
    if ($premiumData) {
        // Convertir 0 y 1 a false y true
        $premiumValue = (bool) $premiumData['premium'];

        echo json_encode(array(
            "respuesta" => true,
            "premium" => $premiumValue // Ahora devuelve true o false
        ));
    } else {
        echo json_encode(array(
            "respuesta" => false,
            "premium" => false,
            "message" => "No se encontraron datos premium para este usuario."
        ));
    }

?>
