<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';


require '../../vendor/autoload.php'; // Autoload de Composer para Firebase

use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;

// Configura Firebase
$factory = (new Factory)->withServiceAccount('tempmail-bb679-4d3e7363f6c3.json'); // <-- Usa el archivo correcto
$auth = $factory->createAuth();

// Obtener el token desde POST
$token = $_GET['Token'] ?? null;

if (!$token) {
    http_response_code(401);
    echo json_encode([
        "respuesta" => false,
        "mensaje" => "Token no proporcionado"
    ]);
    exit;
}

try {
    $verifiedIdToken = $auth->verifyIdToken($token);
    $email = $verifiedIdToken->claims()->get('email'); // Extrae el email desde el token
} catch (\Throwable $e) {
    http_response_code(401);
    echo json_encode([
        "respuesta" => false,
        "mensaje" => "Token Firebase inválido",
        "error" => $e->getMessage()
    ]);
    exit;
}



// Función para formatear la fecha
function formatDate($dateString) {
    $date = new DateTime($dateString);
    return $date->format('d M Y H:i');
}

// Función para decodificar el mensaje según su tipo de codificación
function decodeMessage($message, $encoding) {
    switch ($encoding) {
        case 0: // 7BIT
        case 1: // 8BIT
            return $message;
        case 3: // BASE64
            return base64_decode($message);
        case 4: // QUOTED-PRINTABLE
            return quoted_printable_decode($message);
        default:
            return $message; // No decodificación
    }
}

// Función para obtener la parte HTML de un correo (si existe)
function getPartHTML($structure, $inbox, $email_number) {
    $html_message = '';

    if (isset($structure->parts) && count($structure->parts) > 0) {
        foreach ($structure->parts as $index => $part) {
            if ($part->type == 0 && $part->subtype == 'HTML') {
                $html_message = imap_fetchbody($inbox, $email_number, $index + 1);
                $html_message = decodeMessage($html_message, $part->encoding);
                return $html_message; // Retorna directamente si encuentra HTML
            } elseif ($part->type == 1) { // 1 = MULTIPART
                foreach ($part->parts as $sub_index => $sub_part) {
                    if ($sub_part->subtype == 'HTML') {
                        $html_message = imap_fetchbody($inbox, $email_number, $index + 1 . '.' . ($sub_index + 1));
                        $html_message = decodeMessage($html_message, $sub_part->encoding);
                        return $html_message; // Retorna HTML
                    }
                }
            }
        }
    } else {
        $html_message = imap_fetchbody($inbox, $email_number, 1);
        $html_message = decodeMessage($html_message, $structure->encoding);
    }

    return $html_message;
}

// Función para manejar y mostrar adjuntos
function getAttachments($structure, $inbox, $email_number) {
    $attachments = [];

    if (isset($structure->parts) && count($structure->parts) > 0) {
        foreach ($structure->parts as $index => $part) {
            if (isset($part->disposition) && strtolower($part->disposition) === 'attachment') {
                $attachment = [
                    'filename' => isset($part->parameters[0]->value) ? $part->parameters[0]->value : 'adjunto',
                    'data' => imap_fetchbody($inbox, $email_number, $index + 1),
                    'encoding' => $part->encoding,
                ];

                // Decodificar el archivo según su tipo de codificación
                switch ($attachment['encoding']) {
                    case 3: // BASE64
                        $attachment['data'] = base64_decode($attachment['data']);
                        break;
                    case 4: // QUOTED-PRINTABLE
                        $attachment['data'] = quoted_printable_decode($attachment['data']);
                        break;
                }

                $attachments[] = $attachment;
            }
        }
    }

    return $attachments;
}

// Conectar a la base de datos
$database = new Database();
$db = $database->getConnection();

// Obtener los datos enviados por GET
$correo_verificar = isset($_GET['correo']) ? $_GET['correo'] : '';
$id_email = isset($_GET['id']) ? intval($_GET['id']) : 0; // Obtener el ID del correo

// Sanitizar datos
$usuario = filter_var($usuario, FILTER_SANITIZE_EMAIL);
$correo_verificar = filter_var($correo_verificar, FILTER_SANITIZE_EMAIL);

// Extraer el dominio del correo
$partes = explode('@', $correo_verificar);
$dominio = $partes[1];


    $host = '{mail.' . $dominio . ':993/imap/ssl/novalidate-cert}';
    $username = $correo_verificar;
    $password_imap = '2324DanielGS.'; 

    $inbox = imap_open('{mail.' . $dominio . ':993/imap/ssl/novalidate-cert}INBOX', $username, $password_imap) or die(json_encode(array("error" => imap_last_error())));

    if ($id_email > 0) {
        $overview = imap_fetch_overview($inbox, $id_email, 0);
        $structure = imap_fetchstructure($inbox, $id_email);

        $html_message = getPartHTML($structure, $inbox, $id_email);
        $attachments = getAttachments($structure, $inbox, $id_email);

        if (!empty($html_message)) {
            echo "<!DOCTYPE html>
            <html lang='es'>
            <head>
                <meta charset='UTF-8'>
                <meta name='viewport' content='width=device-width, initial-scale=1.0'>
                <title>Correo Electrónico</title>
                <style>
                    body {
                        margin: 0;
                        padding: 0;
                        font-family: Arial, sans-serif;
                        line-height: 1.5;
                        background-color: #f4f4f4;
                    }
                    .responsive-container {
                        max-width: 600px;
                        margin: 20px auto;
                        padding: 20px;
                        background-color: #fff;
                        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
                    }
                    img {
                        max-width: 100%;
                        height: auto;
                    }
                    .attachments {
                        margin-top: 20px;
                        padding: 10px;
                        background-color: #f9f9f9;
                        border: 1px solid #ddd;
                    }
                    .attachment {
                        margin-bottom: 10px;
                    }
                </style>
            </head>
            <body>
                <div class='responsive-container'>";
            echo $html_message;

            if (!empty($attachments)) {
                echo "<div class='attachments'>";
                echo "<h3>Archivos adjuntos:</h3>";
                foreach ($attachments as $index => $attachment) {
                    $filename = htmlspecialchars($attachment['filename']);
                    $encoded_data = base64_encode($attachment['data']);
                    echo "<div class='attachment'>
                            <a href='data:application/octet-stream;base64,{$encoded_data}' download='{$filename}'>
                                Descargar {$filename}
                            </a>
                          </div>";
                }
                echo "</div>";
            }

            echo "</div>
            </body>
            </html>";
        } else {
            echo "<div>No se pudo obtener el contenido del correo.</div>"; 
        }
    } else {
        echo "ID de correo no válido.";
    }

    imap_close($inbox);

?>
