<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';

// Crear una nueva instancia de la clase Database
$database = new Database();
$conn = $database->getConnection();

// Verificar si el formulario fue enviado por POST
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $correo = trim($_POST['correo']);


    // Verificar si los campos están vacíos
    if (empty($correo)) {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "Faltan datos. El usuario, correo o contraseña son inválidos."
        ));
        exit; // Detener el proceso si hay un error
    }




    // Verificar si el correo proporcionado existe en la base de datos
    $sql_check_correo = "SELECT * FROM correos WHERE correo = :correo";
    $stmt_check = $conn->prepare($sql_check_correo);
    $stmt_check->bindParam(":correo", $correo);
    $stmt_check->execute();
    $correo_data = $stmt_check->fetch(PDO::FETCH_ASSOC);

    if (!$correo_data) {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "El correo no está registrado."
        ));
        exit();
    }

    // Separar usuario y dominio del correo
    $correo_parts = explode('@', $correo);
    $correo_usuario = $correo_parts[0];
    $domain = $correo_parts[1];

    // Obtener la IP de HestiaCP desde la tabla dominios usando el dominio del correo
    $sql_dominio = "SELECT * FROM dominios WHERE dominio = :dominio LIMIT 1";
    $stmt_dominio = $conn->prepare($sql_dominio);
    $stmt_dominio->bindParam(":dominio", $domain);
    $stmt_dominio->execute();
    $row = $stmt_dominio->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "No hay dominios disponibles."
        ));
        exit();
    }

    $hestia_url = $row['ip']; // IP/URL de HestiaCP
    $hestia_user = 'admin'; // Usuario de HestiaCP (ajustar si es necesario)
    $hestia_pass = '2324DanielGS.'; // Contraseña de HestiaCP (ajustar si es necesario)

    // Datos para eliminar el correo en HestiaCP
    $postdata = http_build_query(array(
        'user' => $hestia_user,
        'password' => $hestia_pass,
        'cmd' => 'v-delete-mail-account',
        'arg1' => 'daniel',
        'arg2' => $domain,
        'arg3' => $correo_usuario
    ));

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $hestia_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    $response = curl_exec($ch);
    curl_close($ch);

    if ($response != 'OK') {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "Ocurrió un error al eliminar el correo, intente nuevamente o contacte a soporte.",
            "code" => $response 
        ));
        exit();
    } else {
        // El correo fue eliminado exitosamente en HestiaCP
        // Cambiar el estado del correo a 'false'
        $sql_update = "UPDATE correos SET estado = false WHERE correo = :correo";
        $stmt_update = $conn->prepare($sql_update);
        $stmt_update->bindParam(":correo", $correo);

        if ($stmt_update->execute()) {
            echo json_encode(array(
                "respuesta" => true,
                "mensaje" => "El correo ha sido eliminado."
            ));
        } else {
            echo json_encode(array(
                "respuesta" => false,
                "mensaje" => "Error al actualizar el estado del correo."
            ));
        }
    }

   
}
?>
