<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';

// Conectar a la base de datos
$database = new Database();
$db = $database->getConnection();

// Datos de autenticación de HestiaCP

$hestia_user = 'admin'; // Usuario administrador
$hestia_pass = '2324DanielGS.'; // Contraseña del administrador
$correo = isset($_POST['correo']) ? trim($_POST['correo']) : ''; // Correo del POST
$sesion = isset($_POST['sesion']) ? filter_var($_POST['sesion'], FILTER_VALIDATE_BOOLEAN) : false; // Sesión




// Consultar el estado premium del usuario
$query = "SELECT premium, diadepago FROM premium WHERE email = :email";
$stmt = $db->prepare($query);
$stmt->bindParam(':email', $email);
$stmt->execute();
$row = $stmt->fetch(PDO::FETCH_ASSOC);


$date = new DateTime($row['diadepago']);

// Agregar 30 días
$date->modify('+30 days');


// Establecer el valor de premium
$is_premium = $row ? (bool)$row['premium'] : false;
$fechapremium = $date->format('Y-m-d');
// Insertar en la tabla de sesiones
$timestamp = date("Y-m-d H:i:s"); // Obtén el timestamp actual
$query = "INSERT INTO session (email, timestamp) VALUES (:email, :timestamp)";
$stmt = $db->prepare($query);
$stmt->bindParam(':email', $email);
$stmt->bindParam(':timestamp', $timestamp);
$stmt->execute();

// Si 'sesion' es true, verificar si ya existe un correo activo para este usuario
if ($sesion) {
    $query = "SELECT correo FROM correos WHERE email = :email AND estado = true";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // Si se encuentra un correo con estado activo, lo devuelve
        echo json_encode(array(
            "respuesta" => true,
            "correo" => $row['correo'],
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
        exit(); // Detener el flujo ya que se encontró un correo activo
    }
}

// Si el correo no está vacío, verificar si ya existe en la tabla de correos
if (!empty($correo)) {
    $query = "SELECT COUNT(*) AS count FROM correos WHERE correo = :correo";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':correo', $correo);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row['count'] > 0) {
        // El correo ya existe en la tabla correos
        echo json_encode(array(
            "respuesta" => true,
            "correo" => $correo,
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
    } else {
        // El correo no se encontró
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "El correo no existe.",
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
    }
} else {

    // Verificar límite de correos activos según el tipo de usuario
    $query = "SELECT COUNT(*) AS activos FROM correos WHERE email = :email AND estado = true";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':email', $email);
    $stmt->execute();
    $row_activos = $stmt->fetch(PDO::FETCH_ASSOC);
    $correos_activos = isset($row_activos['activos']) ? intval($row_activos['activos']) : 0;

    if ((!$is_premium && $correos_activos >= 2) || ($is_premium && $correos_activos >= 10)) {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => $is_premium
                ? "Límite de 10 correos activos alcanzado para usuarios premium."
                : "Límite de 2 correos activos alcanzado para usuarios no premium.",
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
        exit();
    }

    // Seleccionar el dominio con menos correos creados
    $query = "SELECT * FROM dominios ORDER BY cantidad ASC LIMIT 1";
    $stmt = $db->prepare($query);
    $stmt->execute();
    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "No hay dominios disponibles.",
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
        exit();
    }

    $domain = $row['dominio']; // Dominio con menos correos creados
    $hestia_url = $row['ip'];
    // Generar correo único y contraseña porque el correo estaba vacío
    $correo_usuario = bin2hex(random_bytes(4)); // Genera una parte aleatoria para el correo
    $password = '2324DanielGS.'; // Contraseña fija

    // Datos que se enviarán a la API de HestiaCP
    $postdata = http_build_query(array(
        'user' => $hestia_user,
        'password' => $hestia_pass,
        'cmd' => 'v-add-mail-account', // Comando de HestiaCP
        'arg1' => 'daniel', // usuario
        'arg2' => $domain, // Dominio
        'arg3' => $correo_usuario, // Nombre de usuario del correo
        'arg4' => $password // Contraseña del correo
    ));

    // Inicializar curl
    $ch = curl_init();

    // Configurar la solicitud curl
    curl_setopt($ch, CURLOPT_URL, $hestia_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postdata);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Para omitir verificación SSL
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);

    // Ejecutar la llamada a la API
    $response = curl_exec($ch);

    // Manejo de errores de la API
    if ($response != 'OK') {
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "Ocurrió un error, intente nuevamente o contacte a soporte.",
            "premium" => $is_premium,
            "diadepago" => $fechapremium
        ));
    } else {
        // Cerrar la conexión curl
        curl_close($ch);
        $activo = true;
        // Registrar en la base de datos
        $query = "INSERT INTO correos (email, correo, estado) VALUES (:email, :correo, :estado)";
        $stmt = $db->prepare($query);
        $correo_completo = $correo_usuario . '@' . $domain;
        $stmt->bindParam(':email', $email);
        $stmt->bindParam(':correo', $correo_completo);
        $stmt->bindParam(':estado', $activo);

        if ($stmt->execute()) {
            // Actualizar la cantidad de correos creados para el dominio seleccionado
            $query = "UPDATE dominios SET cantidad = cantidad + 1 WHERE dominio = :dominio";
            $stmt = $db->prepare($query);
            $stmt->bindParam(':dominio', $domain);
            $stmt->execute();

            echo json_encode(array(
                "respuesta" => true,
                "correo" => $correo_completo,
                "premium" => $is_premium,
                "diadepago" => $fechapremium
            ));
        } else {
            echo json_encode(array(
                "respuesta" => false,
                "mensaje" => "Ocurrió un error en el registro, intente nuevamente o contacte a soporte.",
                "premium" => $is_premium,
                "diadepago" => $fechapremium
            ));
        }
    }
}
?>
