<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';

// Conectar a la base de datos
$database = new Database();
$db = $database->getConnection();


    // Si el usuario existe, buscar los correos que pertenecen a este usuario
    $queryCorreos = "SELECT * FROM correos WHERE email = :email AND estado = true";
    $stmtCorreos = $db->prepare($queryCorreos);
    $stmtCorreos->bindParam(':email', $email);
    $stmtCorreos->execute();

    $correos = $stmtCorreos->fetchAll(PDO::FETCH_ASSOC);

    // Devolver los correos en formato JSON
    if ($correos) {
        echo json_encode(array(
            "respuesta" => true,
            "buzones" => $correos
        ));
    } else {
        echo json_encode(array(
            "respuesta" => false,
            "message" => "No se encontraron correos activos para este usuario."
        ));
    }

?>
