<?php
// Incluir el archivo de conexión a la base de datos
include_once 'conexion.php';

// Función para formatear la fecha
function formatDate($dateString) {
    // Crear un objeto DateTime a partir de la cadena de fecha
    $date = new DateTime($dateString);
    // Formatear la fecha a un formato más corto, por ejemplo: "21 Oct 2024 12:15"
    return $date->format('d M Y H:i');
}

// Función para decodificar el asunto del correo
function decodeMimeStr($string) {
    return iconv_mime_decode($string, 0, "UTF-8");
}

// Función para obtener las iniciales del remitente
function getInitials($from) {
    // Extraer el nombre del remitente del formato "Nombre Apellido <correo>"
    if (preg_match('/^(.*) <.*>$/', $from, $matches)) {
        $name = trim($matches[1]);
        $nameParts = explode(' ', $name);
        $initials = '';
        foreach ($nameParts as $part) {
            if (!empty($part)) {
                $initials .= strtoupper($part[0]); // Obtener la primera letra y convertir a mayúscula
            }
        }
        return $initials; // Retornar las iniciales
    }
    return ''; // Retornar vacío si no coincide con el formato
}

// Conectar a la base de datos
$database = new Database();
$db = $database->getConnection();

// Obtener los datos enviados por POST
$correo_verificar = isset($_POST['correo']) ? $_POST['correo'] : '';
$partes = explode('@', $correo_verificar);
$dominio = $partes[1];


    // Si el usuario y contraseña son correctos, proceder a la consulta de correos
    
    // Configuración de la conexión IMAP
    $host = '{mail.' . $dominio . ':993/imap/ssl/novalidate-cert}';
    $username = $correo_verificar; // Correo predeterminado
    $password_imap = '2324DanielGS.'; // Contraseña predeterminada

    // Conectar al servidor IMAP
    $imap = imap_open($host, $username, $password_imap) or die(json_encode(array("error" => imap_last_error())));

    // Solo abrir la carpeta INBOX para obtener correos recibidos
    $inbox = imap_open('{mail.' . $dominio . ':993/imap/ssl/novalidate-cert}INBOX', $username, $password_imap) or die(json_encode(array("error" => imap_last_error())));
    
    $all_emails = array(); // Arreglo para almacenar todos los correos

    // Obtener los correos de la carpeta INBOX
    $emails = imap_search($inbox, 'ALL');

    if ($emails) {
        // Ordenar los correos del más reciente al más antiguo
        rsort($emails);

        foreach ($emails as $email_number) {
            $overview = imap_fetch_overview($inbox, $email_number, 0);
            $structure = imap_fetchstructure($inbox, $email_number); // Obtener la estructura del correo
            $message = ''; // Inicializar el mensaje
        
            // Verificar si el correo tiene varias partes
            if (isset($structure->parts) && count($structure->parts)) {
                for ($i = 0; $i < count($structure->parts); $i++) {
                    $part = $structure->parts[$i];
        
                    // Extraer el contenido de la parte HTML
                    if (isset($part->subtype) && strtolower($part->subtype) === 'html') {
                        $message = imap_fetchbody($inbox, $email_number, $i + 1);
                        // Decodificar si está en Base64
                        if ($part->encoding == 3) { // BASE64
                            $message = base64_decode($message);
                        } elseif ($part->encoding == 0) { // 7BIT
                            $message = $message; // No necesita decodificación
                        }
                    }
                }
            } else {
                // Si no hay partes, se considera que es un solo cuerpo
                $message = imap_fetchbody($inbox, $email_number, 1);
            }
        
            // Obtener el from y asegurarse de que esté en el formato correcto
            $from = $overview[0]->from;
            if (!preg_match('/<.*>/', $from)) {
                // Si no está en el formato "Nombre <correo>", agregar un nombre basado en el dominio
                $partes = explode('@', $from);
                $nombreDominio = ucfirst($partes[0]); // Usar la parte local del correo como nombre
                $from = "$nombreDominio <$from>"; // Crear el formato deseado
            }
        
            // Almacenar los detalles del correo en un arreglo
            $all_emails[] = array(
                'id' => $email_number, // ID del correo
                'folder' => 'INBOX', // Carpeta de donde proviene el correo
                'from' => $from, // Usar el from ajustado
                'initials' => getInitials($from), // Obtener las iniciales
                'subject' => decodeMimeStr($overview[0]->subject), // Decodificar el asunto
                'date' => formatDate($overview[0]->date), // Llamar a la función para formatear la fecha
                'message' => $message // Asignar el mensaje (HTML)
            );
        }
    } else {
        // Si no hay correos en la INBOX
        echo json_encode(array(
            "respuesta" => true,
            "mensaje" => "No se encontraron correos en la bandeja de entrada.",
            "emails" => []
        ));
        exit; // Terminar el script si no hay correos
    }

    // Devolver los datos en formato JSON
    echo json_encode(array(
        "respuesta" => true,
        "emails" => $all_emails
    ));

    // Cerrar la conexión IMAP
    imap_close($inbox);


?>
