<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");


error_reporting(E_ALL);
ini_set("display_errors", 1);

require '../vendor/autoload.php'; // Autoload de Composer para Firebase

use Kreait\Firebase\Factory;
use Kreait\Firebase\Auth;

$apikey = $_POST['apikey'] ?? null;
$metodo = $_POST['metodo'] ?? null;

// Validar API Key
if ($apikey !== "AIzaSyB3X-12dfGfh6jh45Xr1A7dBwmka1HjLz0") {
    echo json_encode(array(
        "respuesta" => false,
        "mensaje" => "API KEY Invalida"
    ));
    exit;
}


// Configura Firebase
$factory = (new Factory)->withServiceAccount('atencionciudadana-f1202-c51dc1ae7e97.json'); // <-- Usa el archivo correcto
$auth = $factory->createAuth();

// Obtener el token desde POST
$token = $_POST['Token'] ?? null;

if (!$token) {
    http_response_code(401);
    echo json_encode([
        "respuesta" => false,
        "mensaje" => "Token no proporcionado"
    ]);
    exit;
}

try {
    $verifiedIdToken = $auth->verifyIdToken($token);
    $email = $verifiedIdToken->claims()->get('email'); // Extrae el email desde el token
} catch (\Throwable $e) {
    http_response_code(401);
    echo json_encode([
        "respuesta" => false,
        "mensaje" => "Token Firebase inválido",
        "error" => $e->getMessage()
    ]);
    exit;
}

// Procesar métodos protegidos
switch ($metodo) {
    case "agregar_beneficiario":
        include 'agregar_beneficiario.php';
        break;
    case "listar_enlaces":
        include 'listar_enlaces.php';
        break;
    case "premium":
        include 'premium.php';
        break;

        
    case "actualizar_enlace":
        include 'actualizar_enlace.php';
        break;




    case "solicitud_traslado":
        include 'solicitud_traslado.php';
        break;
    case "solicitudes":
        include 'solicitudes.php';
        break;
    case "RegistrarApoyo":
        include 'RegistrarApoyo.php';
        break;
    case "RegistrarToken":
        include 'RegistrarToken.php';
        break;
    case "ListarSolicitudes":
        include 'ListarSolicitudes.php';
        break;
    case "SolicitudPorAprobar":
        include 'SolicitudPorAprobar.php';
        break;
    case "AprobarSolicitud":
        include 'AprobarSolicitud.php';
        break;
    case "ListarSolicitudesAprobadas":
        include 'ListarSolicitudesAprobadas.php';
        break;
    case "SolicitudPorLiberar":
        include 'SolicitudPorLiberar.php';
        break;
        case "LiberarSolicitud":
            include 'LiberarSolicitud.php';
            break;
    case "ListarSolicitudesLiberadas":
        include 'ListarSolicitudesLiberadas.php';
        break;
        case "FinalizarSolicitud":
            include 'FinalizarSolicitud.php';
            break;
    default:
        echo json_encode(array(
            "respuesta" => false,
            "mensaje" => "METODO Invalido"
        ));
        break;
}
?>